
// --------------------------------- VNX_LPS_api.h -------------------------------------------
//
//	Include file for LabBrick attenuator API DLL (Internal version)
//	A similarly named version with only external declarations exists and is used for the SDK release
//
// (c) 2008 - 2019 by Vaunix Corporation, all rights reserved
//
// -------------------------------------------------------------------------------------------


#ifdef VNX_LPS_EXPORTS
#define VNX_LPS_API __declspec(dllexport)
#else
#define VNX_LPS_API __declspec(dllimport) 
#endif

#ifdef __cplusplus
extern "C" {
#endif

#if VNX_STDCALL
#define VB6_API __stdcall
#else
#define VB6_API 
#endif

	// ----------- Global Equates ------------
#define MAXDEVICES 64
#define MAX_MODELNAME 32
#define PROFILE_MAX 50	
#define PROFILE_MAX_RAM 1000	
#define PROFILE_MAX_HR 25
#define MAXCHAN 8				// as of now the largest phase shifter has up to 8 channels

#define SINGLECHN 0x00
#define FOURCHN 0x01
#define EIGHTCHN 0x02
#define MULTICHN  0x03

#define PROFILE_EMPTY 0xFFFF	// we use this as our marker for an empty entry in the profile (which is an unsigned short)

// ----------- Data Types ----------------

#define DEVID unsigned int

// ----------- Mode Bit Masks ------------
#define MODE_SWEEP	0x0000001F			// bottom 5 bits are used to keep the ramp control bits				

// ----------- Profile Control -----------
#define PROFILE_ONCE	1				// play the profile once
#define PROFILE_REPEAT	2				// play the profile repeatedly
#define PROFILE_OFF		0				// stop the profile

// ----------- Command Equates -----------


// Status returns for commands
#define LVSTATUS int

#define STATUS_OK 0
#define BAD_PARAMETER			0x80010000		// out of range input -- frequency outside min/max etc.
#define BAD_HID_IO				0x80020000		// a failure in the Windows I/O subsystem
#define DEVICE_NOT_READY		0x80030000		// device isn't open, no handle, etc.
#define FEATURE_NOT_SUPPORTED	0x80040000		// the selected Lab Brick does not support this function

// Status returns for DevStatus
// The first set are global to the device
#define INVALID_DEVID		0x80000000		// MSB is set if the device ID is invalid
#define DEV_CONNECTED		0x00000001		// LSB is set if a device is connected
#define DEV_OPENED			0x00000002		// set if the device is opened

// Per channel status
#define SWP_ACTIVE			0x00000004		// set if the device is sweeping
#define SWP_UP				0x00000008		// set if the device is ramping up
#define SWP_REPEAT			0x00000010		// set if the device is in continuous ramp mode
#define SWP_BIDIRECTIONAL	0x00000020		// set if the device is in bi-directional ramp mode
#define PROFILE_ACTIVE		0x00000040		// set if a profile is playing

// Internal values in DevStatus (changed in V2)
#define DEV_LOCKED			0x00002000		// set if we don't want read thread updates of the device parameters
#define DEV_RDTHREAD		0x00004000		// set when the read thread is running
#define DEV_V2FEATURES		0x00008000		// set for devices with V2 feature sets
#define DEV_HIRES			0x00010000		// set for HiRes devices

// Masks to select groups of status bits
#define MSK_GLSTATUS		(DEV_CONNECTED + DEV_OPENED + DEV_V2FEATURES + DEV_HIRES)
#define DEVSTATUS_MASK (SWP_ACTIVE | SWP_UP	| SWP_REPEAT | SWP_BIDIRECTIONAL | PROFILE_ACTIVE)

// Feature bits for the feature DWORD 
#define DEFAULT_FEATURES	0x00000000
#define HAS_BIDIR_RAMPS		0x00000001
#define HAS_PROFILES		0x00000002
#define HAS_HIRES			0x00000004
#define HAS_4CHANNELS		0x00000008
#define HAS_8CHANNELS		0x00000010
#define HAS_LONG_PROFILE	0x00000020
#define HAS_MCHANNELS		0x00000040


VNX_LPS_API void VB6_API fnLPS_SetTraceLevel(int tracelevel, int IOtracelevel, bool verbose);		// changed 7-11-16

VNX_LPS_API void VB6_API fnLPS_SetTestMode(bool testmode);
VNX_LPS_API int VB6_API fnLPS_GetNumDevices();
VNX_LPS_API int VB6_API fnLPS_GetDevInfo(DEVID* ActiveDevices);
VNX_LPS_API int VB6_API fnLPS_GetModelNameA(DEVID deviceID, char* ModelName);
VNX_LPS_API int VB6_API fnLPS_GetModelNameW(DEVID deviceID, wchar_t* ModelName);
VNX_LPS_API int VB6_API fnLPS_InitDevice(DEVID deviceID);
VNX_LPS_API int VB6_API fnLPS_CloseDevice(DEVID deviceID);
VNX_LPS_API int VB6_API fnLPS_GetSerialNumber(DEVID deviceID);
VNX_LPS_API int VB6_API fnLPS_GetDLLVersion();
VNX_LPS_API int VB6_API fnLPS_GetDeviceStatus(DEVID deviceID);


VNX_LPS_API LVSTATUS VB6_API fnLPS_SetChannel(DEVID deviceID, int channel);
VNX_LPS_API LVSTATUS VB6_API fnLPS_SetWorkingFrequency(DEVID deviceID, int frequency);

VNX_LPS_API LVSTATUS VB6_API fnLPS_SetPhaseAngle(DEVID deviceID, int phase);
VNX_LPS_API LVSTATUS VB6_API fnLPS_SetPhaseAngleQ(DEVID deviceID, int phase, int channel);
VNX_LPS_API LVSTATUS VB6_API fnLPS_SetPhaseAngleMC(DEVID deviceID, int phase, unsigned long long channelmask);

VNX_LPS_API LVSTATUS VB6_API fnLPS_SetRampStart(DEVID deviceID, int rampstart);
VNX_LPS_API LVSTATUS VB6_API fnLPS_SetRampEnd(DEVID deviceID, int rampstop);
VNX_LPS_API LVSTATUS VB6_API fnLPS_SetPhaseAngleStep(DEVID deviceID, int phasestep);
VNX_LPS_API LVSTATUS VB6_API fnLPS_SetPhaseAngleStepTwo(DEVID deviceID, int phasestep2);

VNX_LPS_API LVSTATUS VB6_API fnLPS_SetDwellTime(DEVID deviceID, int dwelltime);
VNX_LPS_API LVSTATUS VB6_API fnLPS_SetDwellTimeTwo(DEVID deviceID, int dwelltime2);
VNX_LPS_API LVSTATUS VB6_API fnLPS_SetIdleTime(DEVID deviceID, int idletime);
VNX_LPS_API LVSTATUS VB6_API fnLPS_SetHoldTime(DEVID deviceID, int holdtime);

VNX_LPS_API LVSTATUS VB6_API fnLPS_SetProfileElement(DEVID deviceID, int index, int phase);
VNX_LPS_API LVSTATUS VB6_API fnLPS_SetProfileCount(DEVID deviceID, int profilecount);
VNX_LPS_API LVSTATUS VB6_API fnLPS_SetProfileIdleTime(DEVID deviceID, int idletime);
VNX_LPS_API LVSTATUS VB6_API fnLPS_SetProfileDwellTime(DEVID deviceID, int dwelltime);
VNX_LPS_API LVSTATUS VB6_API fnLPS_StartProfile(DEVID deviceID, int mode);
VNX_LPS_API LVSTATUS VB6_API fnLPS_StartProfileMC(DEVID deviceID, int mode, int chmask, bool deferred);

VNX_LPS_API LVSTATUS VB6_API fnLPS_SetRampDirection(DEVID deviceID, bool up);
VNX_LPS_API LVSTATUS VB6_API fnLPS_SetRampMode(DEVID deviceID, bool mode);
VNX_LPS_API LVSTATUS VB6_API fnLPS_SetRampBidirectional(DEVID deviceID, bool bidir_enable);
VNX_LPS_API LVSTATUS VB6_API fnLPS_StartRamp(DEVID deviceID, bool go);
VNX_LPS_API LVSTATUS VB6_API fnLPS_StartRampMC(DEVID deviceID, int mode, int chmask, bool deferred);

VNX_LPS_API LVSTATUS VB6_API fnLPS_SaveSettings(DEVID deviceID);


VNX_LPS_API int VB6_API fnLPS_GetWorkingFrequency(DEVID deviceID);
VNX_LPS_API int VB6_API fnLPS_GetMinWorkingFrequency(DEVID deviceID);
VNX_LPS_API int VB6_API fnLPS_GetMaxWorkingFrequency(DEVID deviceID);

VNX_LPS_API int VB6_API fnLPS_GetPhaseAngle(DEVID deviceID);
VNX_LPS_API int VB6_API fnLPS_GetRampStart(DEVID deviceID);
VNX_LPS_API int VB6_API fnLPS_GetRampEnd(DEVID deviceID);

VNX_LPS_API int VB6_API fnLPS_GetDwellTime(DEVID deviceID);
VNX_LPS_API int VB6_API fnLPS_GetDwellTimeTwo(DEVID deviceID);
VNX_LPS_API int VB6_API fnLPS_GetIdleTime(DEVID deviceID);
VNX_LPS_API int VB6_API fnLPS_GetHoldTime(DEVID deviceID);

VNX_LPS_API int VB6_API fnLPS_GetPhaseAngleStep(DEVID deviceID);
VNX_LPS_API int VB6_API fnLPS_GetPhaseAngleStepTwo(DEVID deviceID);

VNX_LPS_API int VB6_API fnLPS_GetProfileElement(DEVID deviceID, int index);
VNX_LPS_API int VB6_API fnLPS_GetProfileCount(DEVID deviceID);
VNX_LPS_API int VB6_API fnLPS_GetProfileDwellTime(DEVID deviceID);
VNX_LPS_API int VB6_API fnLPS_GetProfileIdleTime(DEVID deviceID);
VNX_LPS_API int VB6_API fnLPS_GetProfileIndex(DEVID deviceID);

VNX_LPS_API int VB6_API fnLPS_GetMaxPhaseShift(DEVID deviceID);
VNX_LPS_API int VB6_API fnLPS_GetMinPhaseShift(DEVID deviceID);
VNX_LPS_API int VB6_API fnLPS_GetMinPhaseStep(DEVID deviceID);

VNX_LPS_API int VB6_API fnLPS_GetFeatures(DEVID deviceID);
VNX_LPS_API int VB6_API fnLPS_GetNumChannels(DEVID deviceID);
VNX_LPS_API int VB6_API fnLPS_GetProfileMaxLength(DEVID deviceID);

VNX_LPS_API char* VB6_API fnLPS_perror(LVSTATUS status);

#ifdef __cplusplus
}
#endif